 ; Ŀ
 ;   Bnn - reposition text above a line.                                   
 ;   Multiple version by text selection only.                              
 ;   Copyright 2001 - 2007 by Rocket Software Ltd.                         
 ;                                                                         
 ; 

 ; Ŀ
 ;   Cleopa - find the point on a line which is closest the midpoint of a  
 ;   text entity.                                                          
 ;   Arguments: Tent, the text entity data list.                           
 ;              Lent, the line entity data list.                           
 ;   Calls nothing.                                                        
 ;   Returns a list of the point, which may or may not be on the line,     
 ;   and the distance from the text midpoint to the point.                 
 ;   Note: that's the text midpoint, not the insertion.                    
 ; 
 (DEFUN CLEOPA (tent lent / ptlist ll ul ur lr txmid othend ten elv pint disa)
 ; Ŀ
 ;   Find the corner points of the entity.                                 
 ; 
  (setq ptlist (tbx (cdr (assoc -1 tent))))
  (setq ll (car ptlist))
  (setq ul (cadr ptlist))
  (setq ur (caddr ptlist))
  (setq lr (cadddr ptlist))
 ; Ŀ
 ;   Get the text midpoint point and angle and a point on a line at a      
 ;   right angle to the text.                                              
 ; 
  (setq txmid (polar ll (angle ll ur) (/ (distance ll ur) 2)))
  (setq othend (polar txmid (angle ur lr) 10))
 ; Ŀ
 ;   Find the intersection of the line and one perpendicular to the text.  
 ; 
  (setq ten (cdr (assoc 10 lent)))
  (setq elv (cdr (assoc 11 lent)))
  (setq pint (inters txmid othend ten elv ()))
  (setq disa (distance txmid pint))
 (list pint disa))
 ; Ŀ
 ;   Cleopa end.                                                           
 ; 

 ; Ŀ
 ;   Tbx - text extents locator and outliner.                              
 ; 
 (DEFUN TBX (enam / aa bb rota cc dd bheigt bwidth llangg lldist ll ul lr ur)
  (setq aa (entget enam))
 ; Ŀ
 ;   The textbox function returns...hang on...from the notes below, a      
 ;   list containing the offset of the lower left point of the text from   
 ;   the 10 association point - typically 0,0,0 - and the offset of the    
 ;   upper right point from the ten point.  These are assuming that the    
 ;   text isn't obliqued or rotated, so if it is the program must adjust   
 ;   accordingly.  This program won't bother with obliquing, rotation is   
 ;   allowed.                                                              
 ; 
  (setq bb (textbox aa))
  (setq rota (cdr (assoc 50 aa)))
  (setq cc (car bb))                    ; ll offset from 10 of text
  (setq dd (cadr bb))                   ; ur offset from 10 of text
  (setq bheigt (- (cadr dd) (cadr cc)))
  (setq bwidth (- (car dd) (car cc)))
  (setq llangg (angle (list 0 0) cc))
  (setq lldist (distance (list 0 0) cc))
  (setq ll (polar (cdr (assoc 10 aa)) (+ llangg rota) lldist))
  (setq ul (polar ll (+ rota (/ pi 2)) bheigt))
  (setq lr (polar ll rota bwidth))
  (setq ur (polar lr (+ rota (/ pi 2)) bheigt))
 ; Ŀ
 ;   We now have the real upper left, upper right, etc. points of the      
 ;   text.                                                                 
 ; 
  (if t
      (progn
           (grdraw ll ul -1)
           (grdraw ul ur -1)
           (grdraw ur lr -1)
           (grdraw lr ll -1)))
 (list ll ul ur lr))
 ; Ŀ
 ;   Tbx end.                                                              
 ; 

 ; Ŀ
 ;   Bnn.                                                                  
 ; 
 (DEFUN BNN (tenam / tent txht updist dndist ptlist ll ul ur lr pa uppa dnpa
                   ss ss2 tangle num linam lent langle enam dista minam mindis)
  (setq tent (entget tenam))
  (setq txht (cdr (assoc 40 tent)))
  (setq tangle (cdr (assoc 50 tent)))
  (setq updist (* 2.5 txht))
  (setq dndist (* 2.5 txht))
 ; Ŀ
 ;   Find the corner points of the entity.                                 
 ; 
  (setq ptlist (tbx tenam))
  (setq ll (car ptlist))
  (setq ul (cadr ptlist))
  (setq ur (caddr ptlist))
  (setq lr (cadddr ptlist))
 ; Ŀ
 ;   Get the text midpoint.                                                
 ; 
  (setq pa (polar ll (angle ll ur) (/ (distance ll ur) 2)))
 ; Ŀ
 ;   Calculate the search positions.                                       
 ; 
  (setq uppa (polar pa (* pi 0.5) updist))
  (setq dnpa (polar pa (* pi 1.5) dndist))
  (grdraw uppa dnpa 5)
 ; Ŀ
 ;   Look there.                                                           
 ; 
  (setq ss (ssget "c" uppa dnpa (list (cons 0 "line"))))
 ; Ŀ
 ;   If there was more then one line, remove any which weren't             
 ;   parallel to the text.                                                 
 ; 
  (setq ss2 (ssadd))
  (if (> (sslength ss) 1)
      (progn
           (setq tangle (cdr (assoc 50 tent)))
           (setq num 0)
           (while (setq linam (ssname ss num))
                  (setq lent (entget linam))
                  (setq langle (angle (cdr (assoc 10 lent))
                                      (cdr (assoc 11 lent))))
                  (if (or (equal langle tangle 0.01)
                          (equal langle (+ tangle pi) 0.01)
                          (equal langle (+ tangle (* 2 pi)) 0.01))
                      (ssadd linam ss2))
                  (setq num (1+ num)))))
 ; Ŀ
 ;   But if this leaves the ss empty, drop back to the old one.            
 ; 
  (if (null (zerop (sslength ss2)))
      (setq ss ss2))
 ; Ŀ
 ;   Now find the closest line to the entity.  Which involves making a     
 ;   closest point on a line subroutine.                                   
 ; 
  (setq num 0)
  (while (setq enam (ssname ss num))
         (setq num (1+ num))
         (setq dista (cadr (cleopa tent (entget enam))))
         (if (or (null mindis) (< dista mindis))
             (progn
                  (setq minam enam)
                  (setq mindis dista))))
 ; Ŀ
 ;   Move the text entity.                                                 
 ; 
  (redraw minam 3)
  (bn tenam minam)
 (princ))
 ; Ŀ
 ;   Subroutine Bnn end.                                                   
 ; 

 ; Ŀ
 ;   Bn.                                                                   
 ; 
 (DEFUN BN (tenam lenam / tent tangle lent ptlist ll ul ur lr txmid cmid
                                           txtop txbas ten elv pint pa anga)
 ; Ŀ
 ;   Get the text and line entity data.                                    
 ; 
  (setq tent (entget tenam))
  (setq tangle (cdr (assoc 50 tent)))
  (setq lent (entget lenam))
 ; Ŀ
 ;   Find the corner points of the entity.                                 
 ; 
  (setq ptlist (tbx tenam))
  (setq ll (car ptlist))
  (setq ul (cadr ptlist))
  (setq ur (caddr ptlist))
  (setq lr (cadddr ptlist))
 ; Ŀ
 ;   Get the text midpoint point and angle and a point on a line at a      
 ;   right angle to the text.                                              
 ; 
  (setq txmid (polar ll (angle ll ur) (/ (distance ll ur) 2)))
  (setq cmid (polar txmid (+ tangle (/ pi 2)) 10)) ; theoretical endpt
 ; Ŀ
 ;   Get the text top and base midpoints.                                  
 ; 
  (setq txtop (polar ul (angle ul ur) (/ (distance ul ur) 2)))
  (setq txbas (polar ll (angle ll lr) (/ (distance ll lr) 2)))
 ; Ŀ
 ;   Find the intersection of the line and one perpendicular to the text.  
 ; 
  (setq ten (cdr (assoc 10 lent)))
  (setq elv (cdr (assoc 11 lent)))
  (setq pint (inters txmid cmid ten elv ()))
  (grdraw txmid pint 2)
 ; Ŀ
 ;   Find a point 1.5 units away from the line towards the text.           
 ; 
  (setq pa (polar txmid (setq anga (angle txmid pint))
                                   (- (distance pint txmid) 1.5)))
 ; Ŀ
 ;   Move the text.                                                        
 ; 
  (if (equal anga (+ tangle (/ pi 2)) 0.01)
      (command ".move" tenam "" txtop pa)
      (command ".move" tenam "" txbas pa))
 (princ))
 ; Ŀ
 ;   Subroutine Bn end.                                                    
 ; 

 ; Ŀ
 ;   Bnn.                                                                  
 ; 
 (DEFUN C:BNN (/ ss num enam)
  (command "undo" "be")
  (setq ss (ssget (list (cons 0 "text"))))
  (setq num 0)
  (while (setq enam (ssname ss num))
         (setq num (1+ num))
         (bnn enam))
  (command "undo" "end")
 (princ))